// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> The localized name of the resource. </summary>
    public readonly partial struct LabServicesSkuCapacityScaleType : IEquatable<LabServicesSkuCapacityScaleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LabServicesSkuCapacityScaleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LabServicesSkuCapacityScaleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ManualValue = "Manual";
        private const string AutomaticValue = "Automatic";

        /// <summary> The capacity is not adjustable in any way. </summary>
        public static LabServicesSkuCapacityScaleType None { get; } = new LabServicesSkuCapacityScaleType(NoneValue);
        /// <summary> The user must manually scale this SKU in and out. </summary>
        public static LabServicesSkuCapacityScaleType Manual { get; } = new LabServicesSkuCapacityScaleType(ManualValue);
        /// <summary> The user is permitted to scale this SKU in and out. </summary>
        public static LabServicesSkuCapacityScaleType Automatic { get; } = new LabServicesSkuCapacityScaleType(AutomaticValue);
        /// <summary> Determines if two <see cref="LabServicesSkuCapacityScaleType"/> values are the same. </summary>
        public static bool operator ==(LabServicesSkuCapacityScaleType left, LabServicesSkuCapacityScaleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LabServicesSkuCapacityScaleType"/> values are not the same. </summary>
        public static bool operator !=(LabServicesSkuCapacityScaleType left, LabServicesSkuCapacityScaleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LabServicesSkuCapacityScaleType"/>. </summary>
        public static implicit operator LabServicesSkuCapacityScaleType(string value) => new LabServicesSkuCapacityScaleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LabServicesSkuCapacityScaleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LabServicesSkuCapacityScaleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
