// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.LabServices.Models
{
    internal static partial class LabServicesProvisioningStateExtensions
    {
        public static string ToSerialString(this LabServicesProvisioningState value) => value switch
        {
            LabServicesProvisioningState.Creating => "Creating",
            LabServicesProvisioningState.Updating => "Updating",
            LabServicesProvisioningState.Deleting => "Deleting",
            LabServicesProvisioningState.Succeeded => "Succeeded",
            LabServicesProvisioningState.Failed => "Failed",
            LabServicesProvisioningState.Locked => "Locked",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabServicesProvisioningState value.")
        };

        public static LabServicesProvisioningState ToLabServicesProvisioningState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Creating")) return LabServicesProvisioningState.Creating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Updating")) return LabServicesProvisioningState.Updating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deleting")) return LabServicesProvisioningState.Deleting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return LabServicesProvisioningState.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return LabServicesProvisioningState.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Locked")) return LabServicesProvisioningState.Locked;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabServicesProvisioningState value.");
        }
    }
}
