// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.LabServices.Models
{
    internal static partial class LabServicesEnableStateExtensions
    {
        public static string ToSerialString(this LabServicesEnableState value) => value switch
        {
            LabServicesEnableState.Enabled => "Enabled",
            LabServicesEnableState.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabServicesEnableState value.")
        };

        public static LabServicesEnableState ToLabServicesEnableState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return LabServicesEnableState.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return LabServicesEnableState.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabServicesEnableState value.");
        }
    }
}
