// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> Support contact information and instructions. </summary>
    public partial class LabPlanSupportInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LabPlanSupportInfo"/>. </summary>
        public LabPlanSupportInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LabPlanSupportInfo"/>. </summary>
        /// <param name="uri"> Support web address. </param>
        /// <param name="email"> Support contact email address. </param>
        /// <param name="phone"> Support contact phone number. </param>
        /// <param name="instructions"> Support instructions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LabPlanSupportInfo(Uri uri, string email, string phone, string instructions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Uri = uri;
            Email = email;
            Phone = phone;
            Instructions = instructions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Support web address. </summary>
        public Uri Uri { get; set; }
        /// <summary> Support contact email address. </summary>
        public string Email { get; set; }
        /// <summary> Support contact phone number. </summary>
        public string Phone { get; set; }
        /// <summary> Support instructions. </summary>
        public string Instructions { get; set; }
    }
}
