// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> Connection profile for how users connect to lab virtual machines. </summary>
    public partial class LabConnectionProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LabConnectionProfile"/>. </summary>
        public LabConnectionProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LabConnectionProfile"/>. </summary>
        /// <param name="webSshAccess"> The enabled access level for Web Access over SSH. </param>
        /// <param name="webRdpAccess"> The enabled access level for Web Access over RDP. </param>
        /// <param name="clientSshAccess"> The enabled access level for Client Access over SSH. </param>
        /// <param name="clientRdpAccess"> The enabled access level for Client Access over RDP. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LabConnectionProfile(LabVirtualMachineConnectionType? webSshAccess, LabVirtualMachineConnectionType? webRdpAccess, LabVirtualMachineConnectionType? clientSshAccess, LabVirtualMachineConnectionType? clientRdpAccess, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WebSshAccess = webSshAccess;
            WebRdpAccess = webRdpAccess;
            ClientSshAccess = clientSshAccess;
            ClientRdpAccess = clientRdpAccess;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The enabled access level for Web Access over SSH. </summary>
        public LabVirtualMachineConnectionType? WebSshAccess { get; set; }
        /// <summary> The enabled access level for Web Access over RDP. </summary>
        public LabVirtualMachineConnectionType? WebRdpAccess { get; set; }
        /// <summary> The enabled access level for Client Access over SSH. </summary>
        public LabVirtualMachineConnectionType? ClientSshAccess { get; set; }
        /// <summary> The enabled access level for Client Access over RDP. </summary>
        public LabVirtualMachineConnectionType? ClientRdpAccess { get; set; }
    }
}
