// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> Profile for how to handle shutting down virtual machines. </summary>
    public partial class LabAutoShutdownProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LabAutoShutdownProfile"/>. </summary>
        public LabAutoShutdownProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LabAutoShutdownProfile"/>. </summary>
        /// <param name="shutdownOnDisconnect"> Whether shutdown on disconnect is enabled. </param>
        /// <param name="shutdownWhenNotConnected"> Whether a VM will get shutdown when it hasn't been connected to after a period of time. </param>
        /// <param name="shutdownOnIdle"> Whether a VM will get shutdown when it has idled for a period of time. </param>
        /// <param name="disconnectDelay"> The amount of time a VM will stay running after a user disconnects if this behavior is enabled. </param>
        /// <param name="noConnectDelay"> The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled. </param>
        /// <param name="idleDelay"> The amount of time a VM will idle before it is shutdown if this behavior is enabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LabAutoShutdownProfile(LabServicesEnableState? shutdownOnDisconnect, LabServicesEnableState? shutdownWhenNotConnected, LabVirtualMachineShutdownOnIdleMode? shutdownOnIdle, TimeSpan? disconnectDelay, TimeSpan? noConnectDelay, TimeSpan? idleDelay, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ShutdownOnDisconnect = shutdownOnDisconnect;
            ShutdownWhenNotConnected = shutdownWhenNotConnected;
            ShutdownOnIdle = shutdownOnIdle;
            DisconnectDelay = disconnectDelay;
            NoConnectDelay = noConnectDelay;
            IdleDelay = idleDelay;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Whether shutdown on disconnect is enabled. </summary>
        public LabServicesEnableState? ShutdownOnDisconnect { get; set; }
        /// <summary> Whether a VM will get shutdown when it hasn't been connected to after a period of time. </summary>
        public LabServicesEnableState? ShutdownWhenNotConnected { get; set; }
        /// <summary> Whether a VM will get shutdown when it has idled for a period of time. </summary>
        public LabVirtualMachineShutdownOnIdleMode? ShutdownOnIdle { get; set; }
        /// <summary> The amount of time a VM will stay running after a user disconnects if this behavior is enabled. </summary>
        public TimeSpan? DisconnectDelay { get; set; }
        /// <summary> The amount of time a VM will stay running before it is shutdown if no connection is made and this behavior is enabled. </summary>
        public TimeSpan? NoConnectDelay { get; set; }
        /// <summary> The amount of time a VM will idle before it is shutdown if this behavior is enabled. </summary>
        public TimeSpan? IdleDelay { get; set; }
    }
}
