// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> The tier of the SKU. </summary>
    public readonly partial struct AvailableLabServicesSkuTier : IEquatable<AvailableLabServicesSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AvailableLabServicesSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AvailableLabServicesSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";

        /// <summary> Standard. </summary>
        public static AvailableLabServicesSkuTier Standard { get; } = new AvailableLabServicesSkuTier(StandardValue);
        /// <summary> Premium. </summary>
        public static AvailableLabServicesSkuTier Premium { get; } = new AvailableLabServicesSkuTier(PremiumValue);
        /// <summary> Determines if two <see cref="AvailableLabServicesSkuTier"/> values are the same. </summary>
        public static bool operator ==(AvailableLabServicesSkuTier left, AvailableLabServicesSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AvailableLabServicesSkuTier"/> values are not the same. </summary>
        public static bool operator !=(AvailableLabServicesSkuTier left, AvailableLabServicesSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AvailableLabServicesSkuTier"/>. </summary>
        public static implicit operator AvailableLabServicesSkuTier(string value) => new AvailableLabServicesSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AvailableLabServicesSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AvailableLabServicesSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
