// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> The array of costs of a lab services SKU. </summary>
    public partial class AvailableLabServicesSkuCost
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AvailableLabServicesSkuCost"/>. </summary>
        internal AvailableLabServicesSkuCost()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AvailableLabServicesSkuCost"/>. </summary>
        /// <param name="meterId"> The meter id. </param>
        /// <param name="quantity"> The quantity of units charged. </param>
        /// <param name="extendedUnit"> The extended unit. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AvailableLabServicesSkuCost(string meterId, float? quantity, string extendedUnit, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MeterId = meterId;
            Quantity = quantity;
            ExtendedUnit = extendedUnit;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The meter id. </summary>
        public string MeterId { get; }
        /// <summary> The quantity of units charged. </summary>
        public float? Quantity { get; }
        /// <summary> The extended unit. </summary>
        public string ExtendedUnit { get; }
    }
}
