// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> The scale out/in options of the SKU. </summary>
    public partial class AvailableLabServicesSkuCapacity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AvailableLabServicesSkuCapacity"/>. </summary>
        internal AvailableLabServicesSkuCapacity()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AvailableLabServicesSkuCapacity"/>. </summary>
        /// <param name="default"> The default capacity for this resource. </param>
        /// <param name="minimum"> The lowest permitted capacity for this resource. </param>
        /// <param name="maximum"> The highest permitted capacity for this resource. </param>
        /// <param name="scaleType"> The localized name of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AvailableLabServicesSkuCapacity(long? @default, long? minimum, long? maximum, LabServicesSkuCapacityScaleType? scaleType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Default = @default;
            Minimum = minimum;
            Maximum = maximum;
            ScaleType = scaleType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The default capacity for this resource. </summary>
        public long? Default { get; }
        /// <summary> The lowest permitted capacity for this resource. </summary>
        public long? Minimum { get; }
        /// <summary> The highest permitted capacity for this resource. </summary>
        public long? Maximum { get; }
        /// <summary> The localized name of the resource. </summary>
        public LabServicesSkuCapacityScaleType? ScaleType { get; }
    }
}
