// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.LabServices
{
    internal class LabPlanOperationSource : IOperationSource<LabPlanResource>
    {
        private readonly ArmClient _client;

        internal LabPlanOperationSource(ArmClient client)
        {
            _client = client;
        }

        LabPlanResource IOperationSource<LabPlanResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = LabPlanData.DeserializeLabPlanData(document.RootElement);
            return new LabPlanResource(_client, data);
        }

        async ValueTask<LabPlanResource> IOperationSource<LabPlanResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = LabPlanData.DeserializeLabPlanData(document.RootElement);
            return new LabPlanResource(_client, data);
        }
    }
}
