// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.LabServices
{
    internal class LabOperationSource : IOperationSource<LabResource>
    {
        private readonly ArmClient _client;

        internal LabOperationSource(ArmClient client)
        {
            _client = client;
        }

        LabResource IOperationSource<LabResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = LabData.DeserializeLabData(document.RootElement);
            return new LabResource(_client, data);
        }

        async ValueTask<LabResource> IOperationSource<LabResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = LabData.DeserializeLabData(document.RootElement);
            return new LabResource(_client, data);
        }
    }
}
