// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.LabServices.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.LabServices
{
    /// <summary>
    /// A class representing the LabVirtualMachine data model.
    /// A lab virtual machine resource.
    /// </summary>
    public partial class LabVirtualMachineData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LabVirtualMachineData"/>. </summary>
        public LabVirtualMachineData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LabVirtualMachineData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Current provisioning state of the virtual machine. </param>
        /// <param name="state"> The current state of the virtual machine. </param>
        /// <param name="connectionProfile"> Profile for information about connecting to the virtual machine. </param>
        /// <param name="claimedByUserId"> The lab user ID (not the PUID!) of who claimed the virtual machine. </param>
        /// <param name="vmType"> The type of this VM resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LabVirtualMachineData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, LabServicesProvisioningState? provisioningState, LabVirtualMachineState? state, LabVirtualMachineConnectionProfile connectionProfile, string claimedByUserId, LabVirtualMachineType? vmType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            State = state;
            ConnectionProfile = connectionProfile;
            ClaimedByUserId = claimedByUserId;
            VmType = vmType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Current provisioning state of the virtual machine. </summary>
        public LabServicesProvisioningState? ProvisioningState { get; }
        /// <summary> The current state of the virtual machine. </summary>
        public LabVirtualMachineState? State { get; }
        /// <summary> Profile for information about connecting to the virtual machine. </summary>
        public LabVirtualMachineConnectionProfile ConnectionProfile { get; }
        /// <summary> The lab user ID (not the PUID!) of who claimed the virtual machine. </summary>
        public string ClaimedByUserId { get; }
        /// <summary> The type of this VM resource. </summary>
        public LabVirtualMachineType? VmType { get; }
    }
}
