// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.LabServices.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.LabServices
{
    /// <summary>
    /// A class representing the LabUser data model.
    /// User of a lab that can register for and use virtual machines within the lab.
    /// </summary>
    public partial class LabUserData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LabUserData"/>. </summary>
        /// <param name="email"> Email address of the user. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="email"/> is null. </exception>
        public LabUserData(string email)
        {
            Argument.AssertNotNull(email, nameof(email));

            Email = email;
        }

        /// <summary> Initializes a new instance of <see cref="LabUserData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="additionalUsageQuota"> The amount of usage quota time the user gets in addition to the lab usage quota. </param>
        /// <param name="provisioningState"> Current provisioning state of the user resource. </param>
        /// <param name="displayName"> Display name of the user, for example user's full name. </param>
        /// <param name="email"> Email address of the user. </param>
        /// <param name="registrationState"> State of the user's registration within the lab. </param>
        /// <param name="invitationState"> State of the invitation message for the user. </param>
        /// <param name="invitationSentOn"> Date and time when the invitation message was sent to the user. </param>
        /// <param name="totalUsage"> How long the user has used their virtual machines in this lab. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LabUserData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, TimeSpan? additionalUsageQuota, LabServicesProvisioningState? provisioningState, string displayName, string email, LabUserRegistrationState? registrationState, LabUserInvitationState? invitationState, DateTimeOffset? invitationSentOn, TimeSpan? totalUsage, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            AdditionalUsageQuota = additionalUsageQuota;
            ProvisioningState = provisioningState;
            DisplayName = displayName;
            Email = email;
            RegistrationState = registrationState;
            InvitationState = invitationState;
            InvitationSentOn = invitationSentOn;
            TotalUsage = totalUsage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LabUserData"/> for deserialization. </summary>
        internal LabUserData()
        {
        }

        /// <summary> The amount of usage quota time the user gets in addition to the lab usage quota. </summary>
        public TimeSpan? AdditionalUsageQuota { get; set; }
        /// <summary> Current provisioning state of the user resource. </summary>
        public LabServicesProvisioningState? ProvisioningState { get; }
        /// <summary> Display name of the user, for example user's full name. </summary>
        public string DisplayName { get; }
        /// <summary> Email address of the user. </summary>
        public string Email { get; set; }
        /// <summary> State of the user's registration within the lab. </summary>
        public LabUserRegistrationState? RegistrationState { get; }
        /// <summary> State of the invitation message for the user. </summary>
        public LabUserInvitationState? InvitationState { get; }
        /// <summary> Date and time when the invitation message was sent to the user. </summary>
        public DateTimeOffset? InvitationSentOn { get; }
        /// <summary> How long the user has used their virtual machines in this lab. </summary>
        public TimeSpan? TotalUsage { get; }
    }
}
