// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.LabServices.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.LabServices
{
    /// <summary>
    /// A class representing the LabPlan data model.
    /// Lab Plans act as a permission container for creating labs via labs.azure.com. Additionally, they can provide a set of default configurations that will apply at the time of creating a lab, but these defaults can still be overwritten.
    /// </summary>
    public partial class LabPlanData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LabPlanData"/>. </summary>
        /// <param name="location"> The location. </param>
        public LabPlanData(AzureLocation location) : base(location)
        {
            AllowedRegions = new ChangeTrackingList<AzureLocation>();
        }

        /// <summary> Initializes a new instance of <see cref="LabPlanData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Managed Identity Information. Current supported identity types: SystemAssigned. </param>
        /// <param name="defaultConnectionProfile"> The default lab connection profile. This can be changed on a lab resource and only provides a default profile. </param>
        /// <param name="defaultAutoShutdownProfile"> The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile. </param>
        /// <param name="defaultNetworkProfile"> The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there are existing labs associated with this lab plan. </param>
        /// <param name="allowedRegions"> The allowed regions for the lab creator to use when creating labs using this lab plan. </param>
        /// <param name="sharedGalleryId"> Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it will be persisted in this gallery. Shared images from the gallery can be made available to use when creating new labs. </param>
        /// <param name="supportInfo"> Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and virtual machine users for all labs in the lab plan. </param>
        /// <param name="linkedLmsInstance"> Base Url of the lms instance this lab plan can link lab rosters against. </param>
        /// <param name="provisioningState"> Current provisioning state of the lab plan. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LabPlanData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ManagedServiceIdentity identity, LabConnectionProfile defaultConnectionProfile, LabAutoShutdownProfile defaultAutoShutdownProfile, LabPlanNetworkProfile defaultNetworkProfile, IList<AzureLocation> allowedRegions, ResourceIdentifier sharedGalleryId, LabPlanSupportInfo supportInfo, Uri linkedLmsInstance, LabServicesProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Identity = identity;
            DefaultConnectionProfile = defaultConnectionProfile;
            DefaultAutoShutdownProfile = defaultAutoShutdownProfile;
            DefaultNetworkProfile = defaultNetworkProfile;
            AllowedRegions = allowedRegions;
            SharedGalleryId = sharedGalleryId;
            SupportInfo = supportInfo;
            LinkedLmsInstance = linkedLmsInstance;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LabPlanData"/> for deserialization. </summary>
        internal LabPlanData()
        {
        }

        /// <summary> Managed Identity Information. Current supported identity types: SystemAssigned. </summary>
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> The default lab connection profile. This can be changed on a lab resource and only provides a default profile. </summary>
        public LabConnectionProfile DefaultConnectionProfile { get; set; }
        /// <summary> The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile. </summary>
        public LabAutoShutdownProfile DefaultAutoShutdownProfile { get; set; }
        /// <summary> The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there are existing labs associated with this lab plan. </summary>
        internal LabPlanNetworkProfile DefaultNetworkProfile { get; set; }
        /// <summary> The external subnet resource id. </summary>
        public ResourceIdentifier DefaultNetworkSubnetId
        {
            get => DefaultNetworkProfile is null ? default : DefaultNetworkProfile.SubnetId;
            set
            {
                if (DefaultNetworkProfile is null)
                    DefaultNetworkProfile = new LabPlanNetworkProfile();
                DefaultNetworkProfile.SubnetId = value;
            }
        }

        /// <summary> The allowed regions for the lab creator to use when creating labs using this lab plan. </summary>
        public IList<AzureLocation> AllowedRegions { get; }
        /// <summary> Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it will be persisted in this gallery. Shared images from the gallery can be made available to use when creating new labs. </summary>
        public ResourceIdentifier SharedGalleryId { get; set; }
        /// <summary> Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and virtual machine users for all labs in the lab plan. </summary>
        public LabPlanSupportInfo SupportInfo { get; set; }
        /// <summary> Base Url of the lms instance this lab plan can link lab rosters against. </summary>
        public Uri LinkedLmsInstance { get; set; }
        /// <summary> Current provisioning state of the lab plan. </summary>
        public LabServicesProvisioningState? ProvisioningState { get; }
    }
}
