// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.LabServices.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.LabServices
{
    /// <summary>
    /// A class representing the Lab data model.
    /// The lab resource.
    /// </summary>
    public partial class LabData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LabData"/>. </summary>
        /// <param name="location"> The location. </param>
        public LabData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="LabData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="autoShutdownProfile"> The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting idle. </param>
        /// <param name="connectionProfile"> The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports are open. </param>
        /// <param name="virtualMachineProfile"> The profile used for creating lab virtual machines. </param>
        /// <param name="securityProfile"> The lab security profile. </param>
        /// <param name="rosterProfile"> The lab user list management profile. </param>
        /// <param name="labPlanId"> The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating a lab via labs.azure.com. Setting a labPlanId on an existing lab provides organization.. </param>
        /// <param name="title"> The title of the lab. </param>
        /// <param name="description"> The description of the lab. </param>
        /// <param name="provisioningState"> Current provisioning state of the lab. </param>
        /// <param name="networkProfile"> The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been created. </param>
        /// <param name="state"> The lab state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LabData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, LabAutoShutdownProfile autoShutdownProfile, LabConnectionProfile connectionProfile, LabVirtualMachineProfile virtualMachineProfile, LabSecurityProfile securityProfile, LabRosterProfile rosterProfile, ResourceIdentifier labPlanId, string title, string description, LabServicesProvisioningState? provisioningState, LabNetworkProfile networkProfile, LabState? state, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            AutoShutdownProfile = autoShutdownProfile;
            ConnectionProfile = connectionProfile;
            VirtualMachineProfile = virtualMachineProfile;
            SecurityProfile = securityProfile;
            RosterProfile = rosterProfile;
            LabPlanId = labPlanId;
            Title = title;
            Description = description;
            ProvisioningState = provisioningState;
            NetworkProfile = networkProfile;
            State = state;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LabData"/> for deserialization. </summary>
        internal LabData()
        {
        }

        /// <summary> The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting idle. </summary>
        public LabAutoShutdownProfile AutoShutdownProfile { get; set; }
        /// <summary> The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports are open. </summary>
        public LabConnectionProfile ConnectionProfile { get; set; }
        /// <summary> The profile used for creating lab virtual machines. </summary>
        public LabVirtualMachineProfile VirtualMachineProfile { get; set; }
        /// <summary> The lab security profile. </summary>
        public LabSecurityProfile SecurityProfile { get; set; }
        /// <summary> The lab user list management profile. </summary>
        public LabRosterProfile RosterProfile { get; set; }
        /// <summary> The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating a lab via labs.azure.com. Setting a labPlanId on an existing lab provides organization.. </summary>
        public ResourceIdentifier LabPlanId { get; set; }
        /// <summary> The title of the lab. </summary>
        public string Title { get; set; }
        /// <summary> The description of the lab. </summary>
        public string Description { get; set; }
        /// <summary> Current provisioning state of the lab. </summary>
        public LabServicesProvisioningState? ProvisioningState { get; }
        /// <summary> The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been created. </summary>
        public LabNetworkProfile NetworkProfile { get; set; }
        /// <summary> The lab state. </summary>
        public LabState? State { get; }
    }
}
