// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.LabServices.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableLabServicesResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableLabServicesResourceGroupResource"/> class for mocking. </summary>
        protected MockableLabServicesResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableLabServicesResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableLabServicesResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of LabPlanResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of LabPlanResources and their operations over a LabPlanResource. </returns>
        public virtual LabPlanCollection GetLabPlans()
        {
            return GetCachedClient(client => new LabPlanCollection(client, Id));
        }

        /// <summary>
        /// Retrieves the properties of a Lab Plan.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labPlans/{labPlanName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LabPlans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LabPlanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="labPlanName"> The name of the lab plan that uniquely identifies it within containing resource group. Used in resource URIs and in UI. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="labPlanName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="labPlanName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<LabPlanResource>> GetLabPlanAsync(string labPlanName, CancellationToken cancellationToken = default)
        {
            return await GetLabPlans().GetAsync(labPlanName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Retrieves the properties of a Lab Plan.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labPlans/{labPlanName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LabPlans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LabPlanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="labPlanName"> The name of the lab plan that uniquely identifies it within containing resource group. Used in resource URIs and in UI. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="labPlanName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="labPlanName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<LabPlanResource> GetLabPlan(string labPlanName, CancellationToken cancellationToken = default)
        {
            return GetLabPlans().Get(labPlanName, cancellationToken);
        }

        /// <summary> Gets a collection of LabResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of LabResources and their operations over a LabResource. </returns>
        public virtual LabCollection GetLabs()
        {
            return GetCachedClient(client => new LabCollection(client, Id));
        }

        /// <summary>
        /// Returns the properties of a lab resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Labs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LabResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="labName"> The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="labName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="labName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<LabResource>> GetLabAsync(string labName, CancellationToken cancellationToken = default)
        {
            return await GetLabs().GetAsync(labName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Returns the properties of a lab resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labs/{labName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Labs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LabResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="labName"> The name of the lab that uniquely identifies it within containing lab plan. Used in resource URIs. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="labName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="labName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<LabResource> GetLab(string labName, CancellationToken cancellationToken = default)
        {
            return GetLabs().Get(labName, cancellationToken);
        }
    }
}
