// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmLabServicesModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="LabServices.LabVirtualMachineImageData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="enabledState"> Is the image enabled. </param>
        /// <param name="provisioningState"> Current provisioning state of the image. </param>
        /// <param name="displayName"> The image display name. </param>
        /// <param name="description"> A description of the image. </param>
        /// <param name="iconUri"> URL of the image icon. </param>
        /// <param name="author"> The image author. </param>
        /// <param name="osType"> The OS Type of the image. </param>
        /// <param name="plan"> The ID of marketplace plan associated with the image (optional). </param>
        /// <param name="termsStatus"> The status of image terms of use (enabled = accepted, disabled = not accepted). </param>
        /// <param name="offer"> The ID of an offer associated with the image. </param>
        /// <param name="publisher"> The ID of the publisher of the image. </param>
        /// <param name="sku"> The image SKU. </param>
        /// <param name="version"> The image version. </param>
        /// <param name="sharedGalleryId"> The ID for the image in the shared gallery. </param>
        /// <param name="availableRegions"> The available regions of the image in the shared gallery. </param>
        /// <param name="osState"> The OS State of the image. </param>
        /// <returns> A new <see cref="LabServices.LabVirtualMachineImageData"/> instance for mocking. </returns>
        public static LabVirtualMachineImageData LabVirtualMachineImageData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, LabServicesEnableState? enabledState = null, LabServicesProvisioningState? provisioningState = null, string displayName = null, string description = null, Uri iconUri = null, string author = null, LabVirtualMachineImageOSType? osType = null, string plan = null, LabServicesEnableState? termsStatus = null, string offer = null, string publisher = null, string sku = null, string version = null, ResourceIdentifier sharedGalleryId = null, IEnumerable<AzureLocation> availableRegions = null, LabVirtualMachineImageOSState? osState = null)
        {
            availableRegions ??= new List<AzureLocation>();

            return new LabVirtualMachineImageData(
                id,
                name,
                resourceType,
                systemData,
                enabledState,
                provisioningState,
                displayName,
                description,
                iconUri,
                author,
                osType,
                plan,
                termsStatus,
                offer,
                publisher,
                sku,
                version,
                sharedGalleryId,
                availableRegions?.ToList(),
                osState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="LabServices.LabPlanData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Managed Identity Information. Current supported identity types: SystemAssigned. </param>
        /// <param name="defaultConnectionProfile"> The default lab connection profile. This can be changed on a lab resource and only provides a default profile. </param>
        /// <param name="defaultAutoShutdownProfile"> The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile. </param>
        /// <param name="defaultNetworkSubnetId"> The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there are existing labs associated with this lab plan. </param>
        /// <param name="allowedRegions"> The allowed regions for the lab creator to use when creating labs using this lab plan. </param>
        /// <param name="sharedGalleryId"> Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it will be persisted in this gallery. Shared images from the gallery can be made available to use when creating new labs. </param>
        /// <param name="supportInfo"> Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and virtual machine users for all labs in the lab plan. </param>
        /// <param name="linkedLmsInstance"> Base Url of the lms instance this lab plan can link lab rosters against. </param>
        /// <param name="provisioningState"> Current provisioning state of the lab plan. </param>
        /// <returns> A new <see cref="LabServices.LabPlanData"/> instance for mocking. </returns>
        public static LabPlanData LabPlanData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, LabConnectionProfile defaultConnectionProfile = null, LabAutoShutdownProfile defaultAutoShutdownProfile = null, ResourceIdentifier defaultNetworkSubnetId = null, IEnumerable<AzureLocation> allowedRegions = null, ResourceIdentifier sharedGalleryId = null, LabPlanSupportInfo supportInfo = null, Uri linkedLmsInstance = null, LabServicesProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            allowedRegions ??= new List<AzureLocation>();

            return new LabPlanData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                defaultConnectionProfile,
                defaultAutoShutdownProfile,
                defaultNetworkSubnetId != null ? new LabPlanNetworkProfile(defaultNetworkSubnetId, serializedAdditionalRawData: null) : null,
                allowedRegions?.ToList(),
                sharedGalleryId,
                supportInfo,
                linkedLmsInstance,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="LabServices.LabData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="autoShutdownProfile"> The resource auto shutdown configuration for the lab. This controls whether actions are taken on resources that are sitting idle. </param>
        /// <param name="connectionProfile"> The connection profile for the lab. This controls settings such as web access to lab resources or whether RDP or SSH ports are open. </param>
        /// <param name="virtualMachineProfile"> The profile used for creating lab virtual machines. </param>
        /// <param name="securityProfile"> The lab security profile. </param>
        /// <param name="rosterProfile"> The lab user list management profile. </param>
        /// <param name="labPlanId"> The ID of the lab plan. Used during resource creation to provide defaults and acts as a permission container when creating a lab via labs.azure.com. Setting a labPlanId on an existing lab provides organization.. </param>
        /// <param name="title"> The title of the lab. </param>
        /// <param name="description"> The description of the lab. </param>
        /// <param name="provisioningState"> Current provisioning state of the lab. </param>
        /// <param name="networkProfile"> The network profile for the lab, typically applied via a lab plan. This profile cannot be modified once a lab has been created. </param>
        /// <param name="state"> The lab state. </param>
        /// <returns> A new <see cref="LabServices.LabData"/> instance for mocking. </returns>
        public static LabData LabData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, LabAutoShutdownProfile autoShutdownProfile = null, LabConnectionProfile connectionProfile = null, LabVirtualMachineProfile virtualMachineProfile = null, LabSecurityProfile securityProfile = null, LabRosterProfile rosterProfile = null, ResourceIdentifier labPlanId = null, string title = null, string description = null, LabServicesProvisioningState? provisioningState = null, LabNetworkProfile networkProfile = null, LabState? state = null)
        {
            tags ??= new Dictionary<string, string>();

            return new LabData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                autoShutdownProfile,
                connectionProfile,
                virtualMachineProfile,
                securityProfile,
                rosterProfile,
                labPlanId,
                title,
                description,
                provisioningState,
                networkProfile,
                state,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LabVirtualMachineProfile"/>. </summary>
        /// <param name="createOption"> Indicates what lab virtual machines are created from. </param>
        /// <param name="imageReference"> The image configuration for lab virtual machines. </param>
        /// <param name="osType"> The OS type of the image. </param>
        /// <param name="sku"> The SKU for the lab. Defines the type of virtual machines used in the lab. </param>
        /// <param name="additionalCapabilitiesInstallGpuDrivers"> Additional VM capabilities. </param>
        /// <param name="usageQuota"> The initial quota alloted to each lab user. Must be a time span between 0 and 9999 hours. </param>
        /// <param name="useSharedPassword"> Enabling this option will use the same password for all user VMs. </param>
        /// <param name="adminUser"> Credentials for the admin user on the VM. </param>
        /// <param name="nonAdminUser"> Credentials for the non-admin user on the VM, if one exists. </param>
        /// <returns> A new <see cref="Models.LabVirtualMachineProfile"/> instance for mocking. </returns>
        public static LabVirtualMachineProfile LabVirtualMachineProfile(LabVirtualMachineCreateOption createOption = default, LabVirtualMachineImageReference imageReference = null, LabVirtualMachineImageOSType? osType = null, LabServicesSku sku = null, LabServicesEnableState? additionalCapabilitiesInstallGpuDrivers = null, TimeSpan usageQuota = default, LabServicesEnableState? useSharedPassword = null, LabVirtualMachineCredential adminUser = null, LabVirtualMachineCredential nonAdminUser = null)
        {
            return new LabVirtualMachineProfile(
                createOption,
                imageReference,
                osType,
                sku,
                additionalCapabilitiesInstallGpuDrivers != null ? new LabVirtualMachineAdditionalCapability(additionalCapabilitiesInstallGpuDrivers, serializedAdditionalRawData: null) : null,
                usageQuota,
                useSharedPassword,
                adminUser,
                nonAdminUser,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LabVirtualMachineImageReference"/>. </summary>
        /// <param name="id"> Image resource ID. </param>
        /// <param name="offer"> The image offer if applicable. </param>
        /// <param name="publisher"> The image publisher. </param>
        /// <param name="sku"> The image SKU. </param>
        /// <param name="version"> The image version specified on creation. </param>
        /// <param name="exactVersion"> The actual version of the image after use. </param>
        /// <returns> A new <see cref="Models.LabVirtualMachineImageReference"/> instance for mocking. </returns>
        public static LabVirtualMachineImageReference LabVirtualMachineImageReference(ResourceIdentifier id = null, string offer = null, string publisher = null, string sku = null, string version = null, string exactVersion = null)
        {
            return new LabVirtualMachineImageReference(
                id,
                offer,
                publisher,
                sku,
                version,
                exactVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LabSecurityProfile"/>. </summary>
        /// <param name="registrationCode"> The registration code for the lab. </param>
        /// <param name="openAccess"> Whether any user or only specified users can register to a lab. </param>
        /// <returns> A new <see cref="Models.LabSecurityProfile"/> instance for mocking. </returns>
        public static LabSecurityProfile LabSecurityProfile(string registrationCode = null, LabServicesEnableState? openAccess = null)
        {
            return new LabSecurityProfile(registrationCode, openAccess, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="LabServices.LabServicesScheduleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="startOn"> When lab user virtual machines will be started. Timestamp offsets will be ignored and timeZoneId is used instead. </param>
        /// <param name="stopOn"> When lab user virtual machines will be stopped. Timestamp offsets will be ignored and timeZoneId is used instead. </param>
        /// <param name="recurrencePattern"> The recurrence pattern of the scheduled actions. </param>
        /// <param name="timeZoneId"> The IANA timezone id for the schedule. </param>
        /// <param name="notes"> Notes for this schedule. </param>
        /// <param name="provisioningState"> Current provisioning state of the schedule. </param>
        /// <returns> A new <see cref="LabServices.LabServicesScheduleData"/> instance for mocking. </returns>
        public static LabServicesScheduleData LabServicesScheduleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? startOn = null, DateTimeOffset? stopOn = null, LabServicesRecurrencePattern recurrencePattern = null, string timeZoneId = null, BinaryData notes = null, LabServicesProvisioningState? provisioningState = null)
        {
            return new LabServicesScheduleData(
                id,
                name,
                resourceType,
                systemData,
                startOn,
                stopOn,
                recurrencePattern,
                timeZoneId,
                notes,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableLabServicesSku"/>. </summary>
        /// <param name="resourceType"> The lab services resource type. </param>
        /// <param name="name"> The name of the SKU. </param>
        /// <param name="tier"> The tier of the SKU. </param>
        /// <param name="size"> The SKU size. </param>
        /// <param name="family"> The family of the SKU. </param>
        /// <param name="capacity"> The scale out/in options of the SKU. </param>
        /// <param name="capabilities"> The capabilities of the SKU. </param>
        /// <param name="locations"> List of locations that are available for a size. </param>
        /// <param name="costs"> Metadata for retrieving price info of a lab services SKUs. </param>
        /// <param name="restrictions"> Restrictions of a lab services SKUs. </param>
        /// <returns> A new <see cref="Models.AvailableLabServicesSku"/> instance for mocking. </returns>
        public static AvailableLabServicesSku AvailableLabServicesSku(string resourceType = null, string name = null, AvailableLabServicesSkuTier? tier = null, string size = null, string family = null, AvailableLabServicesSkuCapacity capacity = null, IEnumerable<AvailableLabServicesSkuCapability> capabilities = null, IEnumerable<AzureLocation> locations = null, IEnumerable<AvailableLabServicesSkuCost> costs = null, IEnumerable<AvailableLabServicesSkuRestrictions> restrictions = null)
        {
            capabilities ??= new List<AvailableLabServicesSkuCapability>();
            locations ??= new List<AzureLocation>();
            costs ??= new List<AvailableLabServicesSkuCost>();
            restrictions ??= new List<AvailableLabServicesSkuRestrictions>();

            return new AvailableLabServicesSku(
                resourceType,
                name,
                tier,
                size,
                family,
                capacity,
                capabilities?.ToList(),
                locations?.ToList(),
                costs?.ToList(),
                restrictions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableLabServicesSkuCapacity"/>. </summary>
        /// <param name="default"> The default capacity for this resource. </param>
        /// <param name="minimum"> The lowest permitted capacity for this resource. </param>
        /// <param name="maximum"> The highest permitted capacity for this resource. </param>
        /// <param name="scaleType"> The localized name of the resource. </param>
        /// <returns> A new <see cref="Models.AvailableLabServicesSkuCapacity"/> instance for mocking. </returns>
        public static AvailableLabServicesSkuCapacity AvailableLabServicesSkuCapacity(long? @default = null, long? minimum = null, long? maximum = null, LabServicesSkuCapacityScaleType? scaleType = null)
        {
            return new AvailableLabServicesSkuCapacity(@default, minimum, maximum, scaleType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableLabServicesSkuCapability"/>. </summary>
        /// <param name="name"> The name of the capability for a SKU. </param>
        /// <param name="value"> The value of the capability for a SKU. </param>
        /// <returns> A new <see cref="Models.AvailableLabServicesSkuCapability"/> instance for mocking. </returns>
        public static AvailableLabServicesSkuCapability AvailableLabServicesSkuCapability(string name = null, string value = null)
        {
            return new AvailableLabServicesSkuCapability(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableLabServicesSkuCost"/>. </summary>
        /// <param name="meterId"> The meter id. </param>
        /// <param name="quantity"> The quantity of units charged. </param>
        /// <param name="extendedUnit"> The extended unit. </param>
        /// <returns> A new <see cref="Models.AvailableLabServicesSkuCost"/> instance for mocking. </returns>
        public static AvailableLabServicesSkuCost AvailableLabServicesSkuCost(string meterId = null, float? quantity = null, string extendedUnit = null)
        {
            return new AvailableLabServicesSkuCost(meterId, quantity, extendedUnit, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableLabServicesSkuRestrictions"/>. </summary>
        /// <param name="labServicesSkuRestrictionType"> The type of restriction. </param>
        /// <param name="values"> The values of the restriction. </param>
        /// <param name="reasonCode"> The reason for the restriction. </param>
        /// <returns> A new <see cref="Models.AvailableLabServicesSkuRestrictions"/> instance for mocking. </returns>
        public static AvailableLabServicesSkuRestrictions AvailableLabServicesSkuRestrictions(LabServicesSkuRestrictionType? labServicesSkuRestrictionType = null, IEnumerable<string> values = null, LabServicesSkuRestrictionReasonCode? reasonCode = null)
        {
            values ??= new List<string>();

            return new AvailableLabServicesSkuRestrictions(labServicesSkuRestrictionType, values?.ToList(), reasonCode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LabServicesUsage"/>. </summary>
        /// <param name="currentValue"> The current usage. </param>
        /// <param name="limit"> The limit integer. </param>
        /// <param name="unit"> The unit details. </param>
        /// <param name="name"> The name. </param>
        /// <param name="id"> The fully qualified arm resource id. </param>
        /// <returns> A new <see cref="Models.LabServicesUsage"/> instance for mocking. </returns>
        public static LabServicesUsage LabServicesUsage(long? currentValue = null, long? limit = null, LabServicesUsageUnit? unit = null, LabServicesUsageName name = null, ResourceIdentifier id = null)
        {
            return new LabServicesUsage(
                currentValue,
                limit,
                unit,
                name,
                id,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LabServicesUsageName"/>. </summary>
        /// <param name="localizedValue"> The localized name of the resource. </param>
        /// <param name="skuInstances"> The instances of the resource. </param>
        /// <param name="value"> The name of the resource. </param>
        /// <returns> A new <see cref="Models.LabServicesUsageName"/> instance for mocking. </returns>
        public static LabServicesUsageName LabServicesUsageName(string localizedValue = null, IEnumerable<string> skuInstances = null, string value = null)
        {
            skuInstances ??= new List<string>();

            return new LabServicesUsageName(localizedValue, skuInstances?.ToList(), value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="LabServices.LabUserData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="additionalUsageQuota"> The amount of usage quota time the user gets in addition to the lab usage quota. </param>
        /// <param name="provisioningState"> Current provisioning state of the user resource. </param>
        /// <param name="displayName"> Display name of the user, for example user's full name. </param>
        /// <param name="email"> Email address of the user. </param>
        /// <param name="registrationState"> State of the user's registration within the lab. </param>
        /// <param name="invitationState"> State of the invitation message for the user. </param>
        /// <param name="invitationSentOn"> Date and time when the invitation message was sent to the user. </param>
        /// <param name="totalUsage"> How long the user has used their virtual machines in this lab. </param>
        /// <returns> A new <see cref="LabServices.LabUserData"/> instance for mocking. </returns>
        public static LabUserData LabUserData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, TimeSpan? additionalUsageQuota = null, LabServicesProvisioningState? provisioningState = null, string displayName = null, string email = null, LabUserRegistrationState? registrationState = null, LabUserInvitationState? invitationState = null, DateTimeOffset? invitationSentOn = null, TimeSpan? totalUsage = null)
        {
            return new LabUserData(
                id,
                name,
                resourceType,
                systemData,
                additionalUsageQuota,
                provisioningState,
                displayName,
                email,
                registrationState,
                invitationState,
                invitationSentOn,
                totalUsage,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="LabServices.LabVirtualMachineData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Current provisioning state of the virtual machine. </param>
        /// <param name="state"> The current state of the virtual machine. </param>
        /// <param name="connectionProfile"> Profile for information about connecting to the virtual machine. </param>
        /// <param name="claimedByUserId"> The lab user ID (not the PUID!) of who claimed the virtual machine. </param>
        /// <param name="vmType"> The type of this VM resource. </param>
        /// <returns> A new <see cref="LabServices.LabVirtualMachineData"/> instance for mocking. </returns>
        public static LabVirtualMachineData LabVirtualMachineData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, LabServicesProvisioningState? provisioningState = null, LabVirtualMachineState? state = null, LabVirtualMachineConnectionProfile connectionProfile = null, string claimedByUserId = null, LabVirtualMachineType? vmType = null)
        {
            return new LabVirtualMachineData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                state,
                connectionProfile,
                claimedByUserId,
                vmType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LabVirtualMachineConnectionProfile"/>. </summary>
        /// <param name="privateIPAddress"> The private IP address of the virtual machine. </param>
        /// <param name="sshAuthority"> Port and host name separated by semicolon for connecting via SSH protocol to the virtual machine. </param>
        /// <param name="sshInBrowserUri"> URL for connecting via SSH protocol to the virtual machine in browser. </param>
        /// <param name="rdpAuthority"> Port and host name separated by semicolon for connecting via RDP protocol to the virtual machine. </param>
        /// <param name="rdpInBrowserUri"> URL for connecting via RDP protocol to the virtual machine in browser. </param>
        /// <param name="adminUsername"> The username used to log on to the virtual machine as admin. </param>
        /// <param name="nonAdminUsername"> The username used to log on to the virtual machine as non-admin, if one exists. </param>
        /// <returns> A new <see cref="Models.LabVirtualMachineConnectionProfile"/> instance for mocking. </returns>
        public static LabVirtualMachineConnectionProfile LabVirtualMachineConnectionProfile(IPAddress privateIPAddress = null, string sshAuthority = null, Uri sshInBrowserUri = null, string rdpAuthority = null, Uri rdpInBrowserUri = null, string adminUsername = null, string nonAdminUsername = null)
        {
            return new LabVirtualMachineConnectionProfile(
                privateIPAddress,
                sshAuthority,
                sshInBrowserUri,
                rdpAuthority,
                rdpInBrowserUri,
                adminUsername,
                nonAdminUsername,
                serializedAdditionalRawData: null);
        }
    }
}
