// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.LabServices.Models;

namespace Azure.ResourceManager.LabServices.Samples
{
    public partial class Sample_LabServicesScheduleResource
    {
        // getSchedule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSchedule()
        {
            // Generated from example definition: specification/labservices/resource-manager/Microsoft.LabServices/stable/2022-08-01/examples/Schedules/getSchedule.json
            // this example is just showing the usage of "Schedules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LabServicesScheduleResource created on azure
            // for more information of creating LabServicesScheduleResource, please refer to the document of LabServicesScheduleResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testrg123";
            string labName = "testlab";
            string scheduleName = "schedule1";
            ResourceIdentifier labServicesScheduleResourceId = LabServicesScheduleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, labName, scheduleName);
            LabServicesScheduleResource labServicesSchedule = client.GetLabServicesScheduleResource(labServicesScheduleResourceId);

            // invoke the operation
            LabServicesScheduleResource result = await labServicesSchedule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LabServicesScheduleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // patchSchedule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PatchSchedule()
        {
            // Generated from example definition: specification/labservices/resource-manager/Microsoft.LabServices/stable/2022-08-01/examples/Schedules/patchSchedule.json
            // this example is just showing the usage of "Schedules_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LabServicesScheduleResource created on azure
            // for more information of creating LabServicesScheduleResource, please refer to the document of LabServicesScheduleResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testrg123";
            string labName = "testlab";
            string scheduleName = "schedule1";
            ResourceIdentifier labServicesScheduleResourceId = LabServicesScheduleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, labName, scheduleName);
            LabServicesScheduleResource labServicesSchedule = client.GetLabServicesScheduleResource(labServicesScheduleResourceId);

            // invoke the operation
            LabServicesSchedulePatch patch = new LabServicesSchedulePatch()
            {
                RecurrencePattern = new LabServicesRecurrencePattern(LabServicesRecurrenceFrequency.Daily, DateTimeOffset.Parse("2020-08-14T23:59:59Z"))
                {
                    Interval = 2,
                },
            };
            LabServicesScheduleResource result = await labServicesSchedule.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LabServicesScheduleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // deleteSchedule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteSchedule()
        {
            // Generated from example definition: specification/labservices/resource-manager/Microsoft.LabServices/stable/2022-08-01/examples/Schedules/deleteSchedule.json
            // this example is just showing the usage of "Schedules_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LabServicesScheduleResource created on azure
            // for more information of creating LabServicesScheduleResource, please refer to the document of LabServicesScheduleResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testrg123";
            string labName = "testlab";
            string scheduleName = "schedule1";
            ResourceIdentifier labServicesScheduleResourceId = LabServicesScheduleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, labName, scheduleName);
            LabServicesScheduleResource labServicesSchedule = client.GetLabServicesScheduleResource(labServicesScheduleResourceId);

            // invoke the operation
            await labServicesSchedule.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
