// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The database suspension details. If the database is suspended, this object contains information related to the database's suspension state. </summary>
    internal partial class SuspensionDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SuspensionDetails"/>. </summary>
        internal SuspensionDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SuspensionDetails"/>. </summary>
        /// <param name="suspensionStartOn"> The starting date and time of the suspension state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SuspensionDetails(DateTimeOffset? suspensionStartOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SuspensionStartOn = suspensionStartOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The starting date and time of the suspension state. </summary>
        public DateTimeOffset? SuspensionStartOn { get; }
    }
}
