// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The type of resource, for instance Microsoft.Kusto/clusters/sandboxCustomImages. </summary>
    public readonly partial struct SandboxCustomImageType : IEquatable<SandboxCustomImageType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SandboxCustomImageType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SandboxCustomImageType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftKustoClustersSandboxCustomImagesValue = "Microsoft.Kusto/clusters/sandboxCustomImages";

        /// <summary> Microsoft.Kusto/clusters/sandboxCustomImages. </summary>
        public static SandboxCustomImageType MicrosoftKustoClustersSandboxCustomImages { get; } = new SandboxCustomImageType(MicrosoftKustoClustersSandboxCustomImagesValue);
        /// <summary> Determines if two <see cref="SandboxCustomImageType"/> values are the same. </summary>
        public static bool operator ==(SandboxCustomImageType left, SandboxCustomImageType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SandboxCustomImageType"/> values are not the same. </summary>
        public static bool operator !=(SandboxCustomImageType left, SandboxCustomImageType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SandboxCustomImageType"/>. </summary>
        public static implicit operator SandboxCustomImageType(string value) => new SandboxCustomImageType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SandboxCustomImageType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SandboxCustomImageType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
