// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The language name, for example Python. </summary>
    public readonly partial struct SandboxCustomImageLanguage : IEquatable<SandboxCustomImageLanguage>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SandboxCustomImageLanguage"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SandboxCustomImageLanguage(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PythonValue = "Python";

        /// <summary> Python. </summary>
        public static SandboxCustomImageLanguage Python { get; } = new SandboxCustomImageLanguage(PythonValue);
        /// <summary> Determines if two <see cref="SandboxCustomImageLanguage"/> values are the same. </summary>
        public static bool operator ==(SandboxCustomImageLanguage left, SandboxCustomImageLanguage right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SandboxCustomImageLanguage"/> values are not the same. </summary>
        public static bool operator !=(SandboxCustomImageLanguage left, SandboxCustomImageLanguage right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SandboxCustomImageLanguage"/>. </summary>
        public static implicit operator SandboxCustomImageLanguage(string value) => new SandboxCustomImageLanguage(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SandboxCustomImageLanguage other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SandboxCustomImageLanguage other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
