// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The role of the cluster in the migration process. </summary>
    public readonly partial struct MigrationClusterRole : IEquatable<MigrationClusterRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MigrationClusterRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MigrationClusterRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SourceValue = "Source";
        private const string DestinationValue = "Destination";

        /// <summary> Source. </summary>
        public static MigrationClusterRole Source { get; } = new MigrationClusterRole(SourceValue);
        /// <summary> Destination. </summary>
        public static MigrationClusterRole Destination { get; } = new MigrationClusterRole(DestinationValue);
        /// <summary> Determines if two <see cref="MigrationClusterRole"/> values are the same. </summary>
        public static bool operator ==(MigrationClusterRole left, MigrationClusterRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MigrationClusterRole"/> values are not the same. </summary>
        public static bool operator !=(MigrationClusterRole left, MigrationClusterRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MigrationClusterRole"/>. </summary>
        public static implicit operator MigrationClusterRole(string value) => new MigrationClusterRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MigrationClusterRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MigrationClusterRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
