// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> Represents a properties of a cluster that is part of a migration. </summary>
    public partial class MigrationClusterProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MigrationClusterProperties"/>. </summary>
        internal MigrationClusterProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MigrationClusterProperties"/>. </summary>
        /// <param name="id"> The resource ID of the cluster. </param>
        /// <param name="uri"> The public URL of the cluster. </param>
        /// <param name="dataIngestionUri"> The public data ingestion URL of the cluster. </param>
        /// <param name="role"> The role of the cluster in the migration process. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MigrationClusterProperties(string id, Uri uri, Uri dataIngestionUri, MigrationClusterRole? role, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Uri = uri;
            DataIngestionUri = dataIngestionUri;
            Role = role;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource ID of the cluster. </summary>
        public string Id { get; }
        /// <summary> The public URL of the cluster. </summary>
        public Uri Uri { get; }
        /// <summary> The public data ingestion URL of the cluster. </summary>
        public Uri DataIngestionUri { get; }
        /// <summary> The role of the cluster in the migration process. </summary>
        public MigrationClusterRole? Role { get; }
    }
}
