// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> SKU tier. </summary>
    public readonly partial struct KustoSkuTier : IEquatable<KustoSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";

        /// <summary> Basic. </summary>
        public static KustoSkuTier Basic { get; } = new KustoSkuTier(BasicValue);
        /// <summary> Standard. </summary>
        public static KustoSkuTier Standard { get; } = new KustoSkuTier(StandardValue);
        /// <summary> Determines if two <see cref="KustoSkuTier"/> values are the same. </summary>
        public static bool operator ==(KustoSkuTier left, KustoSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoSkuTier"/> values are not the same. </summary>
        public static bool operator !=(KustoSkuTier left, KustoSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoSkuTier"/>. </summary>
        public static implicit operator KustoSkuTier(string value) => new KustoSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
