// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> Azure SKU definition. </summary>
    public partial class KustoSku
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KustoSku"/>. </summary>
        /// <param name="name"> SKU name. </param>
        /// <param name="tier"> SKU tier. </param>
        public KustoSku(KustoSkuName name, KustoSkuTier tier)
        {
            Name = name;
            Tier = tier;
        }

        /// <summary> Initializes a new instance of <see cref="KustoSku"/>. </summary>
        /// <param name="name"> SKU name. </param>
        /// <param name="capacity"> The number of instances of the cluster. </param>
        /// <param name="tier"> SKU tier. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KustoSku(KustoSkuName name, int? capacity, KustoSkuTier tier, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Capacity = capacity;
            Tier = tier;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="KustoSku"/> for deserialization. </summary>
        internal KustoSku()
        {
        }

        /// <summary> SKU name. </summary>
        public KustoSkuName Name { get; set; }
        /// <summary> The number of instances of the cluster. </summary>
        public int? Capacity { get; set; }
        /// <summary> SKU tier. </summary>
        public KustoSkuTier Tier { get; set; }
    }
}
