// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The type of resource, Microsoft.Kusto/clusters/databases/scripts. </summary>
    public readonly partial struct KustoScriptType : IEquatable<KustoScriptType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoScriptType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoScriptType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftKustoClustersDatabasesScriptsValue = "Microsoft.Kusto/clusters/databases/scripts";

        /// <summary> Microsoft.Kusto/clusters/databases/scripts. </summary>
        public static KustoScriptType MicrosoftKustoClustersDatabasesScripts { get; } = new KustoScriptType(MicrosoftKustoClustersDatabasesScriptsValue);
        /// <summary> Determines if two <see cref="KustoScriptType"/> values are the same. </summary>
        public static bool operator ==(KustoScriptType left, KustoScriptType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoScriptType"/> values are not the same. </summary>
        public static bool operator !=(KustoScriptType left, KustoScriptType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoScriptType"/>. </summary>
        public static implicit operator KustoScriptType(string value) => new KustoScriptType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoScriptType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoScriptType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
