// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> Principal type. </summary>
    public readonly partial struct KustoPrincipalAssignmentType : IEquatable<KustoPrincipalAssignmentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoPrincipalAssignmentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoPrincipalAssignmentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AppValue = "App";
        private const string GroupValue = "Group";
        private const string UserValue = "User";

        /// <summary> App. </summary>
        public static KustoPrincipalAssignmentType App { get; } = new KustoPrincipalAssignmentType(AppValue);
        /// <summary> Group. </summary>
        public static KustoPrincipalAssignmentType Group { get; } = new KustoPrincipalAssignmentType(GroupValue);
        /// <summary> User. </summary>
        public static KustoPrincipalAssignmentType User { get; } = new KustoPrincipalAssignmentType(UserValue);
        /// <summary> Determines if two <see cref="KustoPrincipalAssignmentType"/> values are the same. </summary>
        public static bool operator ==(KustoPrincipalAssignmentType left, KustoPrincipalAssignmentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoPrincipalAssignmentType"/> values are not the same. </summary>
        public static bool operator !=(KustoPrincipalAssignmentType left, KustoPrincipalAssignmentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoPrincipalAssignmentType"/>. </summary>
        public static implicit operator KustoPrincipalAssignmentType(string value) => new KustoPrincipalAssignmentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoPrincipalAssignmentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoPrincipalAssignmentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
