// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> Message providing the reason why the given name is invalid. </summary>
    public readonly partial struct KustoNameUnavailableReason : IEquatable<KustoNameUnavailableReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoNameUnavailableReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoNameUnavailableReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string AlreadyExistsValue = "AlreadyExists";

        /// <summary> Invalid. </summary>
        public static KustoNameUnavailableReason Invalid { get; } = new KustoNameUnavailableReason(InvalidValue);
        /// <summary> AlreadyExists. </summary>
        public static KustoNameUnavailableReason AlreadyExists { get; } = new KustoNameUnavailableReason(AlreadyExistsValue);
        /// <summary> Determines if two <see cref="KustoNameUnavailableReason"/> values are the same. </summary>
        public static bool operator ==(KustoNameUnavailableReason left, KustoNameUnavailableReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoNameUnavailableReason"/> values are not the same. </summary>
        public static bool operator !=(KustoNameUnavailableReason left, KustoNameUnavailableReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoNameUnavailableReason"/>. </summary>
        public static implicit operator KustoNameUnavailableReason(string value) => new KustoNameUnavailableReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoNameUnavailableReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoNameUnavailableReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
