// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> Language extension image name. </summary>
    public readonly partial struct KustoLanguageExtensionImageName : IEquatable<KustoLanguageExtensionImageName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoLanguageExtensionImageName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoLanguageExtensionImageName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RValue = "R";
        private const string Python3_6_5Value = "Python3_6_5";
        private const string Python3_10_8Value = "Python3_10_8";
        private const string Python3108DLValue = "Python3_10_8_DL";
        private const string PythonCustomImageValue = "PythonCustomImage";

        /// <summary> R. </summary>
        public static KustoLanguageExtensionImageName R { get; } = new KustoLanguageExtensionImageName(RValue);
        /// <summary> Python3_10_8_DL. </summary>
        public static KustoLanguageExtensionImageName Python3108DL { get; } = new KustoLanguageExtensionImageName(Python3108DLValue);
        /// <summary> PythonCustomImage. </summary>
        public static KustoLanguageExtensionImageName PythonCustomImage { get; } = new KustoLanguageExtensionImageName(PythonCustomImageValue);
        /// <summary> Determines if two <see cref="KustoLanguageExtensionImageName"/> values are the same. </summary>
        public static bool operator ==(KustoLanguageExtensionImageName left, KustoLanguageExtensionImageName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoLanguageExtensionImageName"/> values are not the same. </summary>
        public static bool operator !=(KustoLanguageExtensionImageName left, KustoLanguageExtensionImageName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoLanguageExtensionImageName"/>. </summary>
        public static implicit operator KustoLanguageExtensionImageName(string value) => new KustoLanguageExtensionImageName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoLanguageExtensionImageName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoLanguageExtensionImageName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
