// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Kusto.Models
{
    public partial class KustoLanguageExtension : IUtf8JsonSerializable, IJsonModel<KustoLanguageExtension>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<KustoLanguageExtension>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<KustoLanguageExtension>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KustoLanguageExtension>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KustoLanguageExtension)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(LanguageExtensionName))
            {
                writer.WritePropertyName("languageExtensionName"u8);
                writer.WriteStringValue(LanguageExtensionName.Value.ToString());
            }
            if (Optional.IsDefined(LanguageExtensionImageName))
            {
                writer.WritePropertyName("languageExtensionImageName"u8);
                writer.WriteStringValue(LanguageExtensionImageName.Value.ToString());
            }
            if (Optional.IsDefined(LanguageExtensionCustomImageName))
            {
                writer.WritePropertyName("languageExtensionCustomImageName"u8);
                writer.WriteStringValue(LanguageExtensionCustomImageName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        KustoLanguageExtension IJsonModel<KustoLanguageExtension>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KustoLanguageExtension>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KustoLanguageExtension)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeKustoLanguageExtension(document.RootElement, options);
        }

        internal static KustoLanguageExtension DeserializeKustoLanguageExtension(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            KustoLanguageExtensionName? languageExtensionName = default;
            KustoLanguageExtensionImageName? languageExtensionImageName = default;
            string languageExtensionCustomImageName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("languageExtensionName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    languageExtensionName = new KustoLanguageExtensionName(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("languageExtensionImageName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    languageExtensionImageName = new KustoLanguageExtensionImageName(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("languageExtensionCustomImageName"u8))
                {
                    languageExtensionCustomImageName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new KustoLanguageExtension(languageExtensionName, languageExtensionImageName, languageExtensionCustomImageName, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<KustoLanguageExtension>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KustoLanguageExtension>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(KustoLanguageExtension)} does not support writing '{options.Format}' format.");
            }
        }

        KustoLanguageExtension IPersistableModel<KustoLanguageExtension>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KustoLanguageExtension>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeKustoLanguageExtension(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(KustoLanguageExtension)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<KustoLanguageExtension>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
