// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> Kind of the database. </summary>
    internal readonly partial struct KustoKind : IEquatable<KustoKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadWriteValue = "ReadWrite";
        private const string ReadOnlyFollowingValue = "ReadOnlyFollowing";

        /// <summary> ReadWrite. </summary>
        public static KustoKind ReadWrite { get; } = new KustoKind(ReadWriteValue);
        /// <summary> ReadOnlyFollowing. </summary>
        public static KustoKind ReadOnlyFollowing { get; } = new KustoKind(ReadOnlyFollowingValue);
        /// <summary> Determines if two <see cref="KustoKind"/> values are the same. </summary>
        public static bool operator ==(KustoKind left, KustoKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoKind"/> values are not the same. </summary>
        public static bool operator !=(KustoKind left, KustoKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoKind"/>. </summary>
        public static implicit operator KustoKind(string value) => new KustoKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
