// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> Properties of the key vault. </summary>
    public partial class KustoKeyVaultProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KustoKeyVaultProperties"/>. </summary>
        public KustoKeyVaultProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KustoKeyVaultProperties"/>. </summary>
        /// <param name="keyName"> The name of the key vault key. </param>
        /// <param name="keyVersion"> The version of the key vault key. </param>
        /// <param name="keyVaultUri"> The Uri of the key vault. </param>
        /// <param name="userIdentity"> The user assigned identity (ARM resource id) that has access to the key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KustoKeyVaultProperties(string keyName, string keyVersion, Uri keyVaultUri, string userIdentity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyName = keyName;
            KeyVersion = keyVersion;
            KeyVaultUri = keyVaultUri;
            UserIdentity = userIdentity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the key vault key. </summary>
        public string KeyName { get; set; }
        /// <summary> The version of the key vault key. </summary>
        public string KeyVersion { get; set; }
        /// <summary> The Uri of the key vault. </summary>
        public Uri KeyVaultUri { get; set; }
        /// <summary> The user assigned identity (ARM resource id) that has access to the key. </summary>
        public string UserIdentity { get; set; }
    }
}
