// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The data format of the message. Optionally the data format can be added to each message. </summary>
    public readonly partial struct KustoIotHubDataFormat : IEquatable<KustoIotHubDataFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoIotHubDataFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoIotHubDataFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MultiJsonValue = "MULTIJSON";
        private const string JsonValue = "JSON";
        private const string CsvValue = "CSV";
        private const string TsvValue = "TSV";
        private const string ScsvValue = "SCSV";
        private const string SohsvValue = "SOHSV";
        private const string PsvValue = "PSV";
        private const string TxtValue = "TXT";
        private const string RawValue = "RAW";
        private const string SingleJsonValue = "SINGLEJSON";
        private const string AvroValue = "AVRO";
        private const string TsveValue = "TSVE";
        private const string ParquetValue = "PARQUET";
        private const string OrcValue = "ORC";
        private const string ApacheAvroValue = "APACHEAVRO";
        private const string W3CLogFileValue = "W3CLOGFILE";

        /// <summary> MULTIJSON. </summary>
        public static KustoIotHubDataFormat MultiJson { get; } = new KustoIotHubDataFormat(MultiJsonValue);
        /// <summary> JSON. </summary>
        public static KustoIotHubDataFormat Json { get; } = new KustoIotHubDataFormat(JsonValue);
        /// <summary> CSV. </summary>
        public static KustoIotHubDataFormat Csv { get; } = new KustoIotHubDataFormat(CsvValue);
        /// <summary> TSV. </summary>
        public static KustoIotHubDataFormat Tsv { get; } = new KustoIotHubDataFormat(TsvValue);
        /// <summary> SCSV. </summary>
        public static KustoIotHubDataFormat Scsv { get; } = new KustoIotHubDataFormat(ScsvValue);
        /// <summary> SOHSV. </summary>
        public static KustoIotHubDataFormat Sohsv { get; } = new KustoIotHubDataFormat(SohsvValue);
        /// <summary> PSV. </summary>
        public static KustoIotHubDataFormat Psv { get; } = new KustoIotHubDataFormat(PsvValue);
        /// <summary> TXT. </summary>
        public static KustoIotHubDataFormat Txt { get; } = new KustoIotHubDataFormat(TxtValue);
        /// <summary> RAW. </summary>
        public static KustoIotHubDataFormat Raw { get; } = new KustoIotHubDataFormat(RawValue);
        /// <summary> SINGLEJSON. </summary>
        public static KustoIotHubDataFormat SingleJson { get; } = new KustoIotHubDataFormat(SingleJsonValue);
        /// <summary> AVRO. </summary>
        public static KustoIotHubDataFormat Avro { get; } = new KustoIotHubDataFormat(AvroValue);
        /// <summary> TSVE. </summary>
        public static KustoIotHubDataFormat Tsve { get; } = new KustoIotHubDataFormat(TsveValue);
        /// <summary> PARQUET. </summary>
        public static KustoIotHubDataFormat Parquet { get; } = new KustoIotHubDataFormat(ParquetValue);
        /// <summary> ORC. </summary>
        public static KustoIotHubDataFormat Orc { get; } = new KustoIotHubDataFormat(OrcValue);
        /// <summary> APACHEAVRO. </summary>
        public static KustoIotHubDataFormat ApacheAvro { get; } = new KustoIotHubDataFormat(ApacheAvroValue);
        /// <summary> W3CLOGFILE. </summary>
        public static KustoIotHubDataFormat W3CLogFile { get; } = new KustoIotHubDataFormat(W3CLogFileValue);
        /// <summary> Determines if two <see cref="KustoIotHubDataFormat"/> values are the same. </summary>
        public static bool operator ==(KustoIotHubDataFormat left, KustoIotHubDataFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoIotHubDataFormat"/> values are not the same. </summary>
        public static bool operator !=(KustoIotHubDataFormat left, KustoIotHubDataFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoIotHubDataFormat"/>. </summary>
        public static implicit operator KustoIotHubDataFormat(string value) => new KustoIotHubDataFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoIotHubDataFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoIotHubDataFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
