// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The origin of the following setup. </summary>
    public readonly partial struct KustoDatabaseShareOrigin : IEquatable<KustoDatabaseShareOrigin>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoDatabaseShareOrigin"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoDatabaseShareOrigin(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DirectValue = "Direct";
        private const string DataShareValue = "DataShare";
        private const string OtherValue = "Other";

        /// <summary> Direct. </summary>
        public static KustoDatabaseShareOrigin Direct { get; } = new KustoDatabaseShareOrigin(DirectValue);
        /// <summary> DataShare. </summary>
        public static KustoDatabaseShareOrigin DataShare { get; } = new KustoDatabaseShareOrigin(DataShareValue);
        /// <summary> Other. </summary>
        public static KustoDatabaseShareOrigin Other { get; } = new KustoDatabaseShareOrigin(OtherValue);
        /// <summary> Determines if two <see cref="KustoDatabaseShareOrigin"/> values are the same. </summary>
        public static bool operator ==(KustoDatabaseShareOrigin left, KustoDatabaseShareOrigin right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoDatabaseShareOrigin"/> values are not the same. </summary>
        public static bool operator !=(KustoDatabaseShareOrigin left, KustoDatabaseShareOrigin right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoDatabaseShareOrigin"/>. </summary>
        public static implicit operator KustoDatabaseShareOrigin(string value) => new KustoDatabaseShareOrigin(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoDatabaseShareOrigin other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoDatabaseShareOrigin other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
