// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> Indication for database routing information from the data connection, by default only database routing information is allowed. </summary>
    public readonly partial struct KustoDatabaseRouting : IEquatable<KustoDatabaseRouting>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoDatabaseRouting"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoDatabaseRouting(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SingleValue = "Single";
        private const string MultiValue = "Multi";

        /// <summary> Single. </summary>
        public static KustoDatabaseRouting Single { get; } = new KustoDatabaseRouting(SingleValue);
        /// <summary> Multi. </summary>
        public static KustoDatabaseRouting Multi { get; } = new KustoDatabaseRouting(MultiValue);
        /// <summary> Determines if two <see cref="KustoDatabaseRouting"/> values are the same. </summary>
        public static bool operator ==(KustoDatabaseRouting left, KustoDatabaseRouting right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoDatabaseRouting"/> values are not the same. </summary>
        public static bool operator !=(KustoDatabaseRouting left, KustoDatabaseRouting right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoDatabaseRouting"/>. </summary>
        public static implicit operator KustoDatabaseRouting(string value) => new KustoDatabaseRouting(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoDatabaseRouting other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoDatabaseRouting other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
