// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The principals modification kind of the database. </summary>
    public readonly partial struct KustoDatabasePrincipalsModificationKind : IEquatable<KustoDatabasePrincipalsModificationKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoDatabasePrincipalsModificationKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoDatabasePrincipalsModificationKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnionValue = "Union";
        private const string ReplaceValue = "Replace";
        private const string NoneValue = "None";

        /// <summary> Union. </summary>
        public static KustoDatabasePrincipalsModificationKind Union { get; } = new KustoDatabasePrincipalsModificationKind(UnionValue);
        /// <summary> Replace. </summary>
        public static KustoDatabasePrincipalsModificationKind Replace { get; } = new KustoDatabasePrincipalsModificationKind(ReplaceValue);
        /// <summary> None. </summary>
        public static KustoDatabasePrincipalsModificationKind None { get; } = new KustoDatabasePrincipalsModificationKind(NoneValue);
        /// <summary> Determines if two <see cref="KustoDatabasePrincipalsModificationKind"/> values are the same. </summary>
        public static bool operator ==(KustoDatabasePrincipalsModificationKind left, KustoDatabasePrincipalsModificationKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoDatabasePrincipalsModificationKind"/> values are not the same. </summary>
        public static bool operator !=(KustoDatabasePrincipalsModificationKind left, KustoDatabasePrincipalsModificationKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoDatabasePrincipalsModificationKind"/>. </summary>
        public static implicit operator KustoDatabasePrincipalsModificationKind(string value) => new KustoDatabasePrincipalsModificationKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoDatabasePrincipalsModificationKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoDatabasePrincipalsModificationKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
