// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> Database principal type. </summary>
    public readonly partial struct KustoDatabasePrincipalType : IEquatable<KustoDatabasePrincipalType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoDatabasePrincipalType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoDatabasePrincipalType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AppValue = "App";
        private const string GroupValue = "Group";
        private const string UserValue = "User";

        /// <summary> App. </summary>
        public static KustoDatabasePrincipalType App { get; } = new KustoDatabasePrincipalType(AppValue);
        /// <summary> Group. </summary>
        public static KustoDatabasePrincipalType Group { get; } = new KustoDatabasePrincipalType(GroupValue);
        /// <summary> User. </summary>
        public static KustoDatabasePrincipalType User { get; } = new KustoDatabasePrincipalType(UserValue);
        /// <summary> Determines if two <see cref="KustoDatabasePrincipalType"/> values are the same. </summary>
        public static bool operator ==(KustoDatabasePrincipalType left, KustoDatabasePrincipalType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoDatabasePrincipalType"/> values are not the same. </summary>
        public static bool operator !=(KustoDatabasePrincipalType left, KustoDatabasePrincipalType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoDatabasePrincipalType"/>. </summary>
        public static implicit operator KustoDatabasePrincipalType(string value) => new KustoDatabasePrincipalType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoDatabasePrincipalType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoDatabasePrincipalType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
