// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> A class representing database principal entity. </summary>
    public partial class KustoDatabasePrincipal
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KustoDatabasePrincipal"/>. </summary>
        /// <param name="role"> Database principal role. </param>
        /// <param name="name"> Database principal name. </param>
        /// <param name="principalType"> Database principal type. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public KustoDatabasePrincipal(KustoDatabasePrincipalRole role, string name, KustoDatabasePrincipalType principalType)
        {
            Argument.AssertNotNull(name, nameof(name));

            Role = role;
            Name = name;
            PrincipalType = principalType;
        }

        /// <summary> Initializes a new instance of <see cref="KustoDatabasePrincipal"/>. </summary>
        /// <param name="role"> Database principal role. </param>
        /// <param name="name"> Database principal name. </param>
        /// <param name="principalType"> Database principal type. </param>
        /// <param name="fqn"> Database principal fully qualified name. </param>
        /// <param name="email"> Database principal email if exists. </param>
        /// <param name="appId"> Application id - relevant only for application principal type. </param>
        /// <param name="tenantName"> The tenant name of the principal. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KustoDatabasePrincipal(KustoDatabasePrincipalRole role, string name, KustoDatabasePrincipalType principalType, string fqn, string email, string appId, string tenantName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Role = role;
            Name = name;
            PrincipalType = principalType;
            Fqn = fqn;
            Email = email;
            AppId = appId;
            TenantName = tenantName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="KustoDatabasePrincipal"/> for deserialization. </summary>
        internal KustoDatabasePrincipal()
        {
        }

        /// <summary> Database principal role. </summary>
        public KustoDatabasePrincipalRole Role { get; set; }
        /// <summary> Database principal name. </summary>
        public string Name { get; set; }
        /// <summary> Database principal type. </summary>
        public KustoDatabasePrincipalType PrincipalType { get; set; }
        /// <summary> Database principal fully qualified name. </summary>
        public string Fqn { get; set; }
        /// <summary> Database principal email if exists. </summary>
        public string Email { get; set; }
        /// <summary> Application id - relevant only for application principal type. </summary>
        public string AppId { get; set; }
        /// <summary> The tenant name of the principal. </summary>
        public string TenantName { get; }
    }
}
