// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The default principals modification kind. </summary>
    public readonly partial struct KustoDatabaseDefaultPrincipalsModificationKind : IEquatable<KustoDatabaseDefaultPrincipalsModificationKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoDatabaseDefaultPrincipalsModificationKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoDatabaseDefaultPrincipalsModificationKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnionValue = "Union";
        private const string ReplaceValue = "Replace";
        private const string NoneValue = "None";

        /// <summary> Union. </summary>
        public static KustoDatabaseDefaultPrincipalsModificationKind Union { get; } = new KustoDatabaseDefaultPrincipalsModificationKind(UnionValue);
        /// <summary> Replace. </summary>
        public static KustoDatabaseDefaultPrincipalsModificationKind Replace { get; } = new KustoDatabaseDefaultPrincipalsModificationKind(ReplaceValue);
        /// <summary> None. </summary>
        public static KustoDatabaseDefaultPrincipalsModificationKind None { get; } = new KustoDatabaseDefaultPrincipalsModificationKind(NoneValue);
        /// <summary> Determines if two <see cref="KustoDatabaseDefaultPrincipalsModificationKind"/> values are the same. </summary>
        public static bool operator ==(KustoDatabaseDefaultPrincipalsModificationKind left, KustoDatabaseDefaultPrincipalsModificationKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoDatabaseDefaultPrincipalsModificationKind"/> values are not the same. </summary>
        public static bool operator !=(KustoDatabaseDefaultPrincipalsModificationKind left, KustoDatabaseDefaultPrincipalsModificationKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoDatabaseDefaultPrincipalsModificationKind"/>. </summary>
        public static implicit operator KustoDatabaseDefaultPrincipalsModificationKind(string value) => new KustoDatabaseDefaultPrincipalsModificationKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoDatabaseDefaultPrincipalsModificationKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoDatabaseDefaultPrincipalsModificationKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
