// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The KustoDatabaseCallerRole. </summary>
    public readonly partial struct KustoDatabaseCallerRole : IEquatable<KustoDatabaseCallerRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoDatabaseCallerRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoDatabaseCallerRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AdminValue = "Admin";
        private const string NoneValue = "None";

        /// <summary> Admin. </summary>
        public static KustoDatabaseCallerRole Admin { get; } = new KustoDatabaseCallerRole(AdminValue);
        /// <summary> None. </summary>
        public static KustoDatabaseCallerRole None { get; } = new KustoDatabaseCallerRole(NoneValue);
        /// <summary> Determines if two <see cref="KustoDatabaseCallerRole"/> values are the same. </summary>
        public static bool operator ==(KustoDatabaseCallerRole left, KustoDatabaseCallerRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoDatabaseCallerRole"/> values are not the same. </summary>
        public static bool operator !=(KustoDatabaseCallerRole left, KustoDatabaseCallerRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoDatabaseCallerRole"/>. </summary>
        public static implicit operator KustoDatabaseCallerRole(string value) => new KustoDatabaseCallerRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoDatabaseCallerRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoDatabaseCallerRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
