// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The type of resource, Microsoft.Kusto/clusters. </summary>
    public readonly partial struct KustoClusterType : IEquatable<KustoClusterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoClusterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoClusterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftKustoClustersValue = "Microsoft.Kusto/clusters";

        /// <summary> Microsoft.Kusto/clusters. </summary>
        public static KustoClusterType MicrosoftKustoClusters { get; } = new KustoClusterType(MicrosoftKustoClustersValue);
        /// <summary> Determines if two <see cref="KustoClusterType"/> values are the same. </summary>
        public static bool operator ==(KustoClusterType left, KustoClusterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoClusterType"/> values are not the same. </summary>
        public static bool operator !=(KustoClusterType left, KustoClusterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoClusterType"/>. </summary>
        public static implicit operator KustoClusterType(string value) => new KustoClusterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoClusterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoClusterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
