// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6). </summary>
    public readonly partial struct KustoClusterPublicIPType : IEquatable<KustoClusterPublicIPType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoClusterPublicIPType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoClusterPublicIPType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IPv4Value = "IPv4";
        private const string DualStackValue = "DualStack";

        /// <summary> IPv4. </summary>
        public static KustoClusterPublicIPType IPv4 { get; } = new KustoClusterPublicIPType(IPv4Value);
        /// <summary> DualStack. </summary>
        public static KustoClusterPublicIPType DualStack { get; } = new KustoClusterPublicIPType(DualStackValue);
        /// <summary> Determines if two <see cref="KustoClusterPublicIPType"/> values are the same. </summary>
        public static bool operator ==(KustoClusterPublicIPType left, KustoClusterPublicIPType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoClusterPublicIPType"/> values are not the same. </summary>
        public static bool operator !=(KustoClusterPublicIPType left, KustoClusterPublicIPType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoClusterPublicIPType"/>. </summary>
        public static implicit operator KustoClusterPublicIPType(string value) => new KustoClusterPublicIPType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoClusterPublicIPType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoClusterPublicIPType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
