// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Kusto.Models
{
    public partial class KustoClusterPatch : IUtf8JsonSerializable, IJsonModel<KustoClusterPatch>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<KustoClusterPatch>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<KustoClusterPatch>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KustoClusterPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KustoClusterPatch)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Sku))
            {
                writer.WritePropertyName("sku"u8);
                writer.WriteObjectValue(Sku, options);
            }
            if (Optional.IsCollectionDefined(Zones))
            {
                writer.WritePropertyName("zones"u8);
                writer.WriteStartArray();
                foreach (var item in Zones)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                JsonSerializer.Serialize(writer, Identity);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(Uri))
            {
                writer.WritePropertyName("uri"u8);
                writer.WriteStringValue(Uri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(DataIngestionUri))
            {
                writer.WritePropertyName("dataIngestionUri"u8);
                writer.WriteStringValue(DataIngestionUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(StateReason))
            {
                writer.WritePropertyName("stateReason"u8);
                writer.WriteStringValue(StateReason);
            }
            if (Optional.IsCollectionDefined(TrustedExternalTenants))
            {
                writer.WritePropertyName("trustedExternalTenants"u8);
                writer.WriteStartArray();
                foreach (var item in TrustedExternalTenants)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(OptimizedAutoscale))
            {
                writer.WritePropertyName("optimizedAutoscale"u8);
                writer.WriteObjectValue(OptimizedAutoscale, options);
            }
            if (Optional.IsDefined(IsDiskEncryptionEnabled))
            {
                writer.WritePropertyName("enableDiskEncryption"u8);
                writer.WriteBooleanValue(IsDiskEncryptionEnabled.Value);
            }
            if (Optional.IsDefined(IsStreamingIngestEnabled))
            {
                writer.WritePropertyName("enableStreamingIngest"u8);
                writer.WriteBooleanValue(IsStreamingIngestEnabled.Value);
            }
            if (Optional.IsDefined(VirtualNetworkConfiguration))
            {
                writer.WritePropertyName("virtualNetworkConfiguration"u8);
                writer.WriteObjectValue(VirtualNetworkConfiguration, options);
            }
            if (Optional.IsDefined(KeyVaultProperties))
            {
                writer.WritePropertyName("keyVaultProperties"u8);
                writer.WriteObjectValue(KeyVaultProperties, options);
            }
            if (Optional.IsDefined(IsPurgeEnabled))
            {
                writer.WritePropertyName("enablePurge"u8);
                writer.WriteBooleanValue(IsPurgeEnabled.Value);
            }
            if (Optional.IsDefined(LanguageExtensions))
            {
                writer.WritePropertyName("languageExtensions"u8);
                writer.WriteObjectValue(LanguageExtensions, options);
            }
            if (Optional.IsDefined(IsDoubleEncryptionEnabled))
            {
                writer.WritePropertyName("enableDoubleEncryption"u8);
                writer.WriteBooleanValue(IsDoubleEncryptionEnabled.Value);
            }
            if (Optional.IsDefined(PublicNetworkAccess))
            {
                writer.WritePropertyName("publicNetworkAccess"u8);
                writer.WriteStringValue(PublicNetworkAccess.Value.ToString());
            }
            if (Optional.IsCollectionDefined(AllowedIPRangeList))
            {
                writer.WritePropertyName("allowedIpRangeList"u8);
                writer.WriteStartArray();
                foreach (var item in AllowedIPRangeList)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(EngineType))
            {
                writer.WritePropertyName("engineType"u8);
                writer.WriteStringValue(EngineType.Value.ToString());
            }
            if (Optional.IsCollectionDefined(AcceptedAudiences))
            {
                writer.WritePropertyName("acceptedAudiences"u8);
                writer.WriteStartArray();
                foreach (var item in AcceptedAudiences)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IsAutoStopEnabled))
            {
                writer.WritePropertyName("enableAutoStop"u8);
                writer.WriteBooleanValue(IsAutoStopEnabled.Value);
            }
            if (Optional.IsDefined(RestrictOutboundNetworkAccess))
            {
                writer.WritePropertyName("restrictOutboundNetworkAccess"u8);
                writer.WriteStringValue(RestrictOutboundNetworkAccess.Value.ToString());
            }
            if (Optional.IsCollectionDefined(AllowedFqdnList))
            {
                writer.WritePropertyName("allowedFqdnList"u8);
                writer.WriteStartArray();
                foreach (var item in AllowedFqdnList)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PublicIPType))
            {
                writer.WritePropertyName("publicIPType"u8);
                writer.WriteStringValue(PublicIPType.Value.ToString());
            }
            if (Optional.IsDefined(VirtualClusterGraduationProperties))
            {
                writer.WritePropertyName("virtualClusterGraduationProperties"u8);
                writer.WriteStringValue(VirtualClusterGraduationProperties);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PrivateEndpointConnections))
            {
                writer.WritePropertyName("privateEndpointConnections"u8);
                writer.WriteStartArray();
                foreach (var item in PrivateEndpointConnections)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(MigrationCluster))
            {
                writer.WritePropertyName("migrationCluster"u8);
                writer.WriteObjectValue(MigrationCluster, options);
            }
            writer.WriteEndObject();
        }

        KustoClusterPatch IJsonModel<KustoClusterPatch>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KustoClusterPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(KustoClusterPatch)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeKustoClusterPatch(document.RootElement, options);
        }

        internal static KustoClusterPatch DeserializeKustoClusterPatch(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            KustoSku sku = default;
            IList<string> zones = default;
            ManagedServiceIdentity identity = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            KustoClusterState? state = default;
            KustoProvisioningState? provisioningState = default;
            Uri uri = default;
            Uri dataIngestionUri = default;
            string stateReason = default;
            IList<KustoClusterTrustedExternalTenant> trustedExternalTenants = default;
            OptimizedAutoscale optimizedAutoscale = default;
            bool? enableDiskEncryption = default;
            bool? enableStreamingIngest = default;
            KustoClusterVirtualNetworkConfiguration virtualNetworkConfiguration = default;
            KustoKeyVaultProperties keyVaultProperties = default;
            bool? enablePurge = default;
            KustoLanguageExtensionList languageExtensions = default;
            bool? enableDoubleEncryption = default;
            KustoClusterPublicNetworkAccess? publicNetworkAccess = default;
            IList<string> allowedIPRangeList = default;
            KustoClusterEngineType? engineType = default;
            IList<AcceptedAudience> acceptedAudiences = default;
            bool? enableAutoStop = default;
            KustoClusterNetworkAccessFlag? restrictOutboundNetworkAccess = default;
            IList<string> allowedFqdnList = default;
            KustoClusterPublicIPType? publicIPType = default;
            string virtualClusterGraduationProperties = default;
            IReadOnlyList<KustoPrivateEndpointConnectionData> privateEndpointConnections = default;
            MigrationClusterProperties migrationCluster = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sku"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sku = KustoSku.DeserializeKustoSku(property.Value, options);
                    continue;
                }
                if (property.NameEquals("zones"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    zones = array;
                    continue;
                }
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = JsonSerializer.Deserialize<ManagedServiceIdentity>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("state"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            state = new KustoClusterState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new KustoProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("uri"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            uri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("dataIngestionUri"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            dataIngestionUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("stateReason"u8))
                        {
                            stateReason = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("trustedExternalTenants"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<KustoClusterTrustedExternalTenant> array = new List<KustoClusterTrustedExternalTenant>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(KustoClusterTrustedExternalTenant.DeserializeKustoClusterTrustedExternalTenant(item, options));
                            }
                            trustedExternalTenants = array;
                            continue;
                        }
                        if (property0.NameEquals("optimizedAutoscale"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            optimizedAutoscale = OptimizedAutoscale.DeserializeOptimizedAutoscale(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("enableDiskEncryption"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableDiskEncryption = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("enableStreamingIngest"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableStreamingIngest = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("virtualNetworkConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            virtualNetworkConfiguration = KustoClusterVirtualNetworkConfiguration.DeserializeKustoClusterVirtualNetworkConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("keyVaultProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            keyVaultProperties = KustoKeyVaultProperties.DeserializeKustoKeyVaultProperties(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("enablePurge"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enablePurge = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("languageExtensions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            languageExtensions = KustoLanguageExtensionList.DeserializeKustoLanguageExtensionList(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("enableDoubleEncryption"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableDoubleEncryption = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("publicNetworkAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            publicNetworkAccess = new KustoClusterPublicNetworkAccess(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("allowedIpRangeList"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            allowedIPRangeList = array;
                            continue;
                        }
                        if (property0.NameEquals("engineType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            engineType = new KustoClusterEngineType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("acceptedAudiences"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<AcceptedAudience> array = new List<AcceptedAudience>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(AcceptedAudience.DeserializeAcceptedAudience(item, options));
                            }
                            acceptedAudiences = array;
                            continue;
                        }
                        if (property0.NameEquals("enableAutoStop"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableAutoStop = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("restrictOutboundNetworkAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            restrictOutboundNetworkAccess = new KustoClusterNetworkAccessFlag(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("allowedFqdnList"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            allowedFqdnList = array;
                            continue;
                        }
                        if (property0.NameEquals("publicIPType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            publicIPType = new KustoClusterPublicIPType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("virtualClusterGraduationProperties"u8))
                        {
                            virtualClusterGraduationProperties = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("privateEndpointConnections"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<KustoPrivateEndpointConnectionData> array = new List<KustoPrivateEndpointConnectionData>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(KustoPrivateEndpointConnectionData.DeserializeKustoPrivateEndpointConnectionData(item, options));
                            }
                            privateEndpointConnections = array;
                            continue;
                        }
                        if (property0.NameEquals("migrationCluster"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            migrationCluster = MigrationClusterProperties.DeserializeMigrationClusterProperties(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new KustoClusterPatch(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                sku,
                zones ?? new ChangeTrackingList<string>(),
                identity,
                state,
                provisioningState,
                uri,
                dataIngestionUri,
                stateReason,
                trustedExternalTenants ?? new ChangeTrackingList<KustoClusterTrustedExternalTenant>(),
                optimizedAutoscale,
                enableDiskEncryption,
                enableStreamingIngest,
                virtualNetworkConfiguration,
                keyVaultProperties,
                enablePurge,
                languageExtensions,
                enableDoubleEncryption,
                publicNetworkAccess,
                allowedIPRangeList ?? new ChangeTrackingList<string>(),
                engineType,
                acceptedAudiences ?? new ChangeTrackingList<AcceptedAudience>(),
                enableAutoStop,
                restrictOutboundNetworkAccess,
                allowedFqdnList ?? new ChangeTrackingList<string>(),
                publicIPType,
                virtualClusterGraduationProperties,
                privateEndpointConnections ?? new ChangeTrackingList<KustoPrivateEndpointConnectionData>(),
                migrationCluster,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<KustoClusterPatch>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KustoClusterPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(KustoClusterPatch)} does not support writing '{options.Format}' format.");
            }
        }

        KustoClusterPatch IPersistableModel<KustoClusterPatch>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<KustoClusterPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeKustoClusterPatch(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(KustoClusterPatch)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<KustoClusterPatch>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
