// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The engine type. </summary>
    public readonly partial struct KustoClusterEngineType : IEquatable<KustoClusterEngineType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KustoClusterEngineType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KustoClusterEngineType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string V2Value = "V2";
        private const string V3Value = "V3";

        /// <summary> V2. </summary>
        public static KustoClusterEngineType V2 { get; } = new KustoClusterEngineType(V2Value);
        /// <summary> V3. </summary>
        public static KustoClusterEngineType V3 { get; } = new KustoClusterEngineType(V3Value);
        /// <summary> Determines if two <see cref="KustoClusterEngineType"/> values are the same. </summary>
        public static bool operator ==(KustoClusterEngineType left, KustoClusterEngineType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KustoClusterEngineType"/> values are not the same. </summary>
        public static bool operator !=(KustoClusterEngineType left, KustoClusterEngineType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KustoClusterEngineType"/>. </summary>
        public static implicit operator KustoClusterEngineType(string value) => new KustoClusterEngineType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KustoClusterEngineType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KustoClusterEngineType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
