// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The name of blob storage event type to process. </summary>
    public readonly partial struct BlobStorageEventType : IEquatable<BlobStorageEventType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BlobStorageEventType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BlobStorageEventType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftStorageBlobCreatedValue = "Microsoft.Storage.BlobCreated";
        private const string MicrosoftStorageBlobRenamedValue = "Microsoft.Storage.BlobRenamed";

        /// <summary> Microsoft.Storage.BlobCreated. </summary>
        public static BlobStorageEventType MicrosoftStorageBlobCreated { get; } = new BlobStorageEventType(MicrosoftStorageBlobCreatedValue);
        /// <summary> Microsoft.Storage.BlobRenamed. </summary>
        public static BlobStorageEventType MicrosoftStorageBlobRenamed { get; } = new BlobStorageEventType(MicrosoftStorageBlobRenamedValue);
        /// <summary> Determines if two <see cref="BlobStorageEventType"/> values are the same. </summary>
        public static bool operator ==(BlobStorageEventType left, BlobStorageEventType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BlobStorageEventType"/> values are not the same. </summary>
        public static bool operator !=(BlobStorageEventType left, BlobStorageEventType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BlobStorageEventType"/>. </summary>
        public static implicit operator BlobStorageEventType(string value) => new BlobStorageEventType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BlobStorageEventType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BlobStorageEventType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
