// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Kusto.Models
{
    /// <summary> The type of resource, for instance Microsoft.Kusto/clusters/attachedDatabaseConfigurations. </summary>
    public readonly partial struct AttachedDatabaseType : IEquatable<AttachedDatabaseType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AttachedDatabaseType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AttachedDatabaseType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftKustoClustersAttachedDatabaseConfigurationsValue = "Microsoft.Kusto/clusters/attachedDatabaseConfigurations";

        /// <summary> Microsoft.Kusto/clusters/attachedDatabaseConfigurations. </summary>
        public static AttachedDatabaseType MicrosoftKustoClustersAttachedDatabaseConfigurations { get; } = new AttachedDatabaseType(MicrosoftKustoClustersAttachedDatabaseConfigurationsValue);
        /// <summary> Determines if two <see cref="AttachedDatabaseType"/> values are the same. </summary>
        public static bool operator ==(AttachedDatabaseType left, AttachedDatabaseType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AttachedDatabaseType"/> values are not the same. </summary>
        public static bool operator !=(AttachedDatabaseType left, AttachedDatabaseType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AttachedDatabaseType"/>. </summary>
        public static implicit operator AttachedDatabaseType(string value) => new AttachedDatabaseType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AttachedDatabaseType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AttachedDatabaseType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
