// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Kusto
{
    internal class SandboxCustomImageOperationSource : IOperationSource<SandboxCustomImageResource>
    {
        private readonly ArmClient _client;

        internal SandboxCustomImageOperationSource(ArmClient client)
        {
            _client = client;
        }

        SandboxCustomImageResource IOperationSource<SandboxCustomImageResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SandboxCustomImageData.DeserializeSandboxCustomImageData(document.RootElement);
            return new SandboxCustomImageResource(_client, data);
        }

        async ValueTask<SandboxCustomImageResource> IOperationSource<SandboxCustomImageResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SandboxCustomImageData.DeserializeSandboxCustomImageData(document.RootElement);
            return new SandboxCustomImageResource(_client, data);
        }
    }
}
