// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Kusto
{
    internal class KustoManagedPrivateEndpointOperationSource : IOperationSource<KustoManagedPrivateEndpointResource>
    {
        private readonly ArmClient _client;

        internal KustoManagedPrivateEndpointOperationSource(ArmClient client)
        {
            _client = client;
        }

        KustoManagedPrivateEndpointResource IOperationSource<KustoManagedPrivateEndpointResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = KustoManagedPrivateEndpointData.DeserializeKustoManagedPrivateEndpointData(document.RootElement);
            return new KustoManagedPrivateEndpointResource(_client, data);
        }

        async ValueTask<KustoManagedPrivateEndpointResource> IOperationSource<KustoManagedPrivateEndpointResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = KustoManagedPrivateEndpointData.DeserializeKustoManagedPrivateEndpointData(document.RootElement);
            return new KustoManagedPrivateEndpointResource(_client, data);
        }
    }
}
