// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Kusto
{
    internal class KustoDatabaseOperationSource : IOperationSource<KustoDatabaseResource>
    {
        private readonly ArmClient _client;

        internal KustoDatabaseOperationSource(ArmClient client)
        {
            _client = client;
        }

        KustoDatabaseResource IOperationSource<KustoDatabaseResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = KustoDatabaseData.DeserializeKustoDatabaseData(document.RootElement);
            return new KustoDatabaseResource(_client, data);
        }

        async ValueTask<KustoDatabaseResource> IOperationSource<KustoDatabaseResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = KustoDatabaseData.DeserializeKustoDatabaseData(document.RootElement);
            return new KustoDatabaseResource(_client, data);
        }
    }
}
