// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Kusto
{
    internal class KustoClusterPrincipalAssignmentOperationSource : IOperationSource<KustoClusterPrincipalAssignmentResource>
    {
        private readonly ArmClient _client;

        internal KustoClusterPrincipalAssignmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        KustoClusterPrincipalAssignmentResource IOperationSource<KustoClusterPrincipalAssignmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = KustoClusterPrincipalAssignmentData.DeserializeKustoClusterPrincipalAssignmentData(document.RootElement);
            return new KustoClusterPrincipalAssignmentResource(_client, data);
        }

        async ValueTask<KustoClusterPrincipalAssignmentResource> IOperationSource<KustoClusterPrincipalAssignmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = KustoClusterPrincipalAssignmentData.DeserializeKustoClusterPrincipalAssignmentData(document.RootElement);
            return new KustoClusterPrincipalAssignmentResource(_client, data);
        }
    }
}
